/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.client.tooltips;

import com.cobblemon.mod.common.CobblemonItemComponents;
import com.cobblemon.mod.common.api.cooking.Flavour;
import com.cobblemon.mod.common.api.cooking.Seasonings;
import com.cobblemon.mod.common.api.riding.stats.RidingStat;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.client.tooltips.SeasoningTooltipHelperKt;
import com.cobblemon.mod.common.client.tooltips.TooltipGenerator;
import com.cobblemon.mod.common.item.components.BaitEffectsComponent;
import com.cobblemon.mod.common.item.components.FlavourComponent;
import com.cobblemon.mod.common.item.components.FoodComponent;
import com.cobblemon.mod.common.item.components.MobEffectsComponent;
import com.cobblemon.mod.common.item.components.RideBoostsComponent;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_1293;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ-\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016\u00a2\u0006\u0004\b\u000b\u0010\n\u00a8\u0006\f"}, d2={"Lcom/cobblemon/mod/common/client/tooltips/SeasoningTooltipGenerator;", "Lcom/cobblemon/mod/common/client/tooltips/TooltipGenerator;", "<init>", "()V", "Lnet/minecraft/class_1799;", "stack", "", "Lnet/minecraft/class_2561;", "lines", "generateCategoryTooltip", "(Lnet/minecraft/class_1799;Ljava/util/List;)Ljava/util/List;", "generateAdditionalTooltip", "common"})
@SourceDebugExtension(value={"SMAP\nSeasoningTooltipGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SeasoningTooltipGenerator.kt\ncom/cobblemon/mod/common/client/tooltips/SeasoningTooltipGenerator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,93:1\n1#2:94\n188#3,3:95\n*S KotlinDebug\n*F\n+ 1 SeasoningTooltipGenerator.kt\ncom/cobblemon/mod/common/client/tooltips/SeasoningTooltipGenerator\n*L\n78#1:95,3\n*E\n"})
public final class SeasoningTooltipGenerator
extends TooltipGenerator {
    @NotNull
    public static final SeasoningTooltipGenerator INSTANCE = new SeasoningTooltipGenerator();

    private SeasoningTooltipGenerator() {
    }

    @Override
    @Nullable
    public List<class_2561> generateCategoryTooltip(@NotNull class_1799 stack, @NotNull List<class_2561> lines) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter(lines, (String)"lines");
        boolean isSeasoningIngredient = Seasonings.INSTANCE.isSeasoning(stack);
        FlavourComponent flavourComponent = (FlavourComponent)stack.method_57824(CobblemonItemComponents.FLAVOUR);
        Map<Flavour, Integer> flavors = flavourComponent != null ? flavourComponent.getFlavours() : null;
        BaitEffectsComponent baitEffectsComponent = (BaitEffectsComponent)stack.method_57824(CobblemonItemComponents.BAIT_EFFECTS);
        List<class_2960> baitEffects = baitEffectsComponent != null ? baitEffectsComponent.getEffects() : null;
        MobEffectsComponent mobEffectsComponent = (MobEffectsComponent)stack.method_57824(CobblemonItemComponents.MOB_EFFECTS);
        List<class_1293> mobEffects = mobEffectsComponent != null ? mobEffectsComponent.getMobEffects() : null;
        RideBoostsComponent rideBoostsComponent = (RideBoostsComponent)stack.method_57824(CobblemonItemComponents.RIDE_BOOST);
        Map<RidingStat, Integer> boosts = rideBoostsComponent != null ? rideBoostsComponent.getBoosts() : null;
        List result = new ArrayList();
        if (!isSeasoningIngredient && flavors == null && baitEffects == null && mobEffects == null) {
            return null;
        }
        if (isSeasoningIngredient) {
            if (Seasonings.INSTANCE.hasFlavors(stack)) {
                result.add(SeasoningTooltipHelperKt.getFlavorSeasoningHeader());
            }
            if (Seasonings.INSTANCE.hasFood(stack)) {
                result.add(SeasoningTooltipHelperKt.getFoodSeasoningHeader());
            }
            if (Seasonings.INSTANCE.hasMobEffect(stack)) {
                result.add(SeasoningTooltipHelperKt.getMobEffectSeasoningHeader());
            }
            if (Seasonings.INSTANCE.hasBaitEffects(stack)) {
                result.add(SeasoningTooltipHelperKt.getBaitEffectSeasoningHeader());
            }
        } else {
            Map<Enum, Integer> map = flavors;
            if (!(map == null || map.isEmpty())) {
                class_5250 class_52502 = LocalizationUtilsKt.lang("seasoning_flavor_header", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"lang(...)");
                result.add(TextKt.blue(class_52502));
            }
            if (!((map = (Collection)mobEffects) == null || map.isEmpty())) {
                class_5250 class_52503 = LocalizationUtilsKt.lang("seasoning_mob_effect_header", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)class_52503, (String)"lang(...)");
                result.add(TextKt.blue(class_52503));
            }
            if (!((map = (Collection)baitEffects) == null || map.isEmpty())) {
                class_5250 class_52504 = LocalizationUtilsKt.lang("seasoning_bait_effect_header", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)class_52504, (String)"lang(...)");
                result.add(TextKt.blue(class_52504));
            }
            if (!((map = boosts) == null || map.isEmpty())) {
                class_5250 class_52505 = LocalizationUtilsKt.lang("seasoning_ride_boosts_info_header", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)class_52505, (String)"lang(...)");
                result.add(TextKt.blue(class_52505));
            }
        }
        return !((Collection)result).isEmpty() ? result : null;
    }

    @Override
    @Nullable
    public List<class_2561> generateAdditionalTooltip(@NotNull class_1799 stack, @NotNull List<class_2561> lines) {
        Map<Flavour, Integer> flavorData;
        Map<Flavour, Integer> map;
        Map<RidingStat, Integer> rideBoosts;
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter(lines, (String)"lines");
        boolean isSeasoningIngredient = Seasonings.INSTANCE.isSeasoning(stack);
        FlavourComponent flavourComponent = (FlavourComponent)stack.method_57824(CobblemonItemComponents.FLAVOUR);
        Map<Flavour, Integer> flavors = flavourComponent != null ? flavourComponent.getFlavours() : null;
        FoodComponent food = (FoodComponent)stack.method_57824(CobblemonItemComponents.FOOD);
        BaitEffectsComponent baitEffectsComponent = (BaitEffectsComponent)stack.method_57824(CobblemonItemComponents.BAIT_EFFECTS);
        List<class_2960> baitEffects = baitEffectsComponent != null ? baitEffectsComponent.getEffects() : null;
        RideBoostsComponent rideBoostsComponent = (RideBoostsComponent)stack.method_57824(CobblemonItemComponents.RIDE_BOOST);
        Map<RidingStat, Integer> map2 = rideBoosts = rideBoostsComponent != null ? rideBoostsComponent.getBoosts() : null;
        if (!isSeasoningIngredient && flavors == null && food == null && baitEffects == null && rideBoosts == null) {
            return null;
        }
        List result = new ArrayList();
        Map<Flavour, Integer> it = map = Seasonings.INSTANCE.getFlavoursFromItemStack(stack);
        boolean bl = false;
        Map<Flavour, Integer> map3 = it;
        Map<Flavour, Integer> map4 = !(map3 == null || map3.isEmpty()) ? map : null;
        if (map4 == null) {
            map4 = flavors;
        }
        if ((flavorData = map4) != null) {
            boolean bl2;
            block8: {
                Map<Flavour, Integer> $this$any$iv = flavorData;
                boolean $i$f$any = false;
                if ($this$any$iv.isEmpty()) {
                    bl2 = false;
                } else {
                    Iterator<Map.Entry<Flavour, Integer>> iterator = $this$any$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<Flavour, Integer> element$iv;
                        Map.Entry<Flavour, Integer> it2 = element$iv = iterator.next();
                        boolean bl3 = false;
                        if (!(((Number)it2.getValue()).intValue() != 0)) continue;
                        bl2 = true;
                        break block8;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                result.addAll(SeasoningTooltipHelperKt.generateAdditionalFlavorTooltip(flavorData));
            }
        }
        if (Seasonings.INSTANCE.hasBaitEffects(stack) || baitEffects != null) {
            result.addAll(SeasoningTooltipHelperKt.generateAdditionalBaitEffectTooltip(stack));
        }
        result.addAll(SeasoningTooltipHelperKt.generateAdditionalRideBoostsTooltip(stack));
        return !((Collection)result).isEmpty() ? result : null;
    }
}

